package aisexpert.backend.ais

import aisexpert.backend.spring.AisCommand
import aisexpert.backend.spring.AisService
import aisexpert.backend.spring.AisTag
import java.time.OffsetDateTime

enum class AisLogLevel {
    NONE,
    ERROR,
    WARNING,
    INFO,
    VERBOSE,
    DEBUG,
    DEBUG2
}

data class EventLogListCommand(
    val filter: EventFilter,
    val paging: PagingRequest,

    // лишние поля
    val items: List<Any> = emptyList()
)

data class EventLogItem(
    val createDate: OffsetDateTime,
    val userId: String?,
    val taskId: String?,
    val userName: String?,
    val taskName: String?,
    val level: AisLogLevel,
    val description: String,
    val location: String?
)

data class EventFilter(
    val userId: String? = null,
    val taskId: String? = null,
    val selectAll: Boolean = false,
    val createDate: TimeRange = TimeRange(),
    val descendSort: Boolean = false
)

data class EventLogListAnswer(
    val items: List<EventLogItem>,
    val paging: PagingResponse
)

@AisService
interface AisEventLogService {
    @AisCommand("87f3207f-8f65-4be9-8841-9b55fcb6c23f")
    fun list(@AisTag authId: Long, command: EventLogListCommand): EventLogListAnswer
}