package aisexpert.backend.ais

import aisexpert.backend.spring.AisCommand
import aisexpert.backend.spring.AisService
import aisexpert.backend.spring.AisTag
import java.time.OffsetDateTime

data class ModelDto(
    val id: String,
    val taskId: String,
    val userId: String?,
    val createDate: OffsetDateTime?,
    val name: String,
    val description: String,
    val period: TimeRange,
    val periodReal: TimeRange,
    val isPublic: Boolean,
    val rowsOutdated: Int,
    val isPeriodic: Boolean,
    val isArchive: Boolean
)

data class ModelEditCommand(
    val id: String,
    val userId: String?,
    val name: String,
    val description: String,
    val isPublic: Boolean
)

data class ModelDeleteCommand(
    val id: String,
    val userId: String,
    val force: Boolean
)

data class ModelInfoCommand(
    val id: String,
    val userId: String?
)

data class ModelFilter(
    val id: String? = null,
    val taskId: String? = null,
    val userId: String? = null,
    val name: String = "",
    val createDate: TimeRange = TimeRange(),
    val dataPeriod: TimeRange = TimeRange(),
    val show: ShowFilter = ShowFilter.SELF,
    val otherUsers: List<String> = emptyList(),
    val archive: ArchiveFilter = ArchiveFilter.NO
)

data class ModelListCommand(
    val filter: ModelFilter = ModelFilter(),
    val paging: PagingRequest = PagingRequest(),

    // лишние поля
    val items: List<Any> = emptyList()
)

data class ModelListAnswer(
    val items: List<ModelDto>
)

@AisService
interface AisModelService {
    @AisCommand(type = "16a56acd-e551-41d9-ac0c-e0ed9f1fab78")
    fun edit(@AisTag authId: Long, command: ModelEditCommand)

    @AisCommand(type = "7615c9e3-b236-4365-9b0b-ada257f17bba")
    fun delete(@AisTag authId: Long, command: ModelDeleteCommand)

    @AisCommand(type = "28c510a8-7923-46ed-89a5-5699362b8bc5")
    fun info(@AisTag authId: Long, command: ModelInfoCommand): ModelDto

    @AisCommand(type = "829aef04-b7d0-4efa-9906-69369c0a30f0")
    fun list(@AisTag authId: Long, command: ModelListCommand): ModelListAnswer
}