package aisexpert.backend.ais

import aisexpert.backend.spring.AisCommand
import aisexpert.backend.spring.AisService
import aisexpert.backend.spring.AisTag

data class NotifyAddressDto(
    val id: String,
    val name: String,
    val email: String,
    val triggers: List<String>
)

data class NotifyAddressCreateCommand(
    val name: String,
    val email: String,
    val triggers: List<String>,

    // лишние поля
    val id: String? = null
)

data class NotifyAddressDeleteCommand(
    val id: String
)

data class NotifyAddressInfoCommand(
    val id: String
)

data class NotifyAddressListCommand(
    // лишние поля
    val items: List<Any> = emptyList()
)

data class NotifyAddressListAnswer(
    val items: List<NotifyAddressDto>
)

@AisService
interface AisNotifyAddressService {
    @AisCommand("18e8a60f-6b25-4903-bfb1-991e850cd8d5")
    fun create(@AisTag authId: Long, command: NotifyAddressCreateCommand): NotifyAddressDto

    @AisCommand("822f52be-fae0-4a28-bc41-b1fafeb137cc")
    fun edit(@AisTag authId: Long, command: NotifyAddressDto): NotifyAddressDto

    @AisCommand("86765158-c347-456c-b410-912f28664aa6")
    fun delete(@AisTag authId: Long, command: NotifyAddressDeleteCommand)

    @AisCommand("bb147aa5-9231-4e59-9788-ddef800a4e9a")
    fun info(@AisTag authId: Long, command: NotifyAddressInfoCommand): NotifyAddressDto

    @AisCommand("02702123-a260-4986-a02e-1a17254e8e11")
    fun list(@AisTag authId: Long, command: NotifyAddressListCommand): NotifyAddressListAnswer
}