package aisexpert.backend.ais

import aisexpert.backend.spring.AisCommand
import aisexpert.backend.spring.AisService
import aisexpert.backend.spring.AisTag
import io.swagger.annotations.ApiModelProperty

data class NotifyTriggerDto(
    val id: String,

    @ApiModelProperty("короткое имя триггера (30 символов)")
    val name: String,

    @ApiModelProperty("тип триггера: cpu (%), ram (%), hdd (%), cputmp (*C), foms (да/нет)")
    val type: String,

    @ApiModelProperty("порог срабатывания")
    val threshold: Int,

    @ApiModelProperty("интервал отправки повторного сообщения (в минутах)")
    val emissionInterval: Int,

    @ApiModelProperty("тема почтового сообщения (100 символов)")
    val subject: String,

    @ApiModelProperty("тело почтового сообщения (1000 символов)")
    val messageTemplate: String
)

data class NotifyTriggerCreateCommand(
    val name: String,
    val type: String,
    val threshold: Int,
    val emissionInterval: Int,
    val subject: String,
    val messageTemplate: String,

    // лишние поля
    val id: String? = null
)

data class NotifyTriggerDeleteCommand(
    val id: String
)

data class NotifyTriggerInfoCommand(
    val id: String
)

data class NotifyTriggerListCommand(
    // лишние поля
    val items: List<Any> = emptyList()
)

data class NotifyTriggerListAnswer(
    val items: List<NotifyTriggerDto>
)

@AisService
interface AisNotifyTriggerService {
    @AisCommand("a12a2a6c-e888-4b33-93fa-9d2428d29c8c")
    fun create(@AisTag authId: Long, command: NotifyTriggerCreateCommand): NotifyTriggerDto

    @AisCommand("0748b67f-88f8-4015-b87e-fcea834cb84b")
    fun edit(@AisTag authId: Long, command: NotifyTriggerDto): NotifyTriggerDto

    @AisCommand("2e2467ab-3544-492e-a2ff-d862be323f58")
    fun delete(@AisTag authId: Long, command: NotifyTriggerDeleteCommand)

    @AisCommand("abf0d51b-8c63-40af-8ab7-fcaad953e84c")
    fun info(@AisTag authId: Long, command: NotifyTriggerInfoCommand): NotifyTriggerDto

    @AisCommand("a118e57e-d8e1-418d-82d4-8e157f521539")
    fun list(@AisTag authId: Long, command: NotifyTriggerListCommand): NotifyTriggerListAnswer
}