package aisexpert.backend.ais

import aisexpert.backend.spring.AisCommand
import aisexpert.backend.spring.AisService
import aisexpert.backend.spring.AisTag
import java.time.OffsetDateTime

data class NsiVidmp(
    val id: Int,
    val name: String
)

data class NsiVidmpCommand(
    val scoreId: String,
    val items: List<NsiVidmp> = emptyList()
)

data class NsiVidmpAnswer(
    val items: List<NsiVidmp>
)

data class NsiProfile(
    val id: Int,
    val name: String
)

data class NsiProfileCommand(
    val scoreId: String,
    val items: List<NsiProfile> = emptyList()
)

data class NsiProfileAnswer(
    val items: List<NsiProfile>
)

data class NsiLpu(
    val code: Int,
    val fullName: String,
    val shortName: String
)

data class NsiLpuFilter(
    val scoreId: String,
    val lpuSearch: String = ""
)

data class NsiLpuCommand(
    val filter: NsiLpuFilter,
    val items: List<NsiLpu> = emptyList()
)

data class NsiLpuAnswer(
    val items: List<NsiLpu>
)

data class NsiMkb(
    val mkbCode: String,
    val mkbName: String
)

data class NsiMkbFilter(
    val scoreId: String,
    val parentId: Int = -1,
    val mkbSearch: String = "",
    val onlyMkbCode: Boolean = false
)

data class NsiMkbCommand(
    val filter: NsiMkbFilter,
    val items: List<NsiMkb> = emptyList()
)

data class NsiMkbAnswer(
    val items: List<NsiMkb>
)

data class NsiSyncDto(
    val taskId: String,
    val isEnabled: Boolean,
    val inProgress: Boolean,
    val runDateTime: OffsetDateTime,
    val nextDateTime: OffsetDateTime,
    val taskExecStatus: TaskExecStatus,
    val attemptLimit: Int,
    val attemptInterval: Int
)

@AisService
interface AisNsiService {
    @AisCommand("18d4ba47-95aa-45c1-8ed4-5f888638f90a")
    fun vidmp(@AisTag authId: Long, command: NsiVidmpCommand): NsiVidmpAnswer

    @AisCommand("d1da093d-346e-45ff-88cf-75a97cc94e6f")
    fun profile(@AisTag authId: Long, command: NsiProfileCommand): NsiProfileAnswer

    @AisCommand("d0fa1b55-2f33-4b32-b189-1fd8a78e98d5")
    fun lpu(@AisTag authId: Long, command: NsiLpuCommand): NsiLpuAnswer

    @AisCommand("a2322349-7629-426d-9e36-b36e6a5a8099")
    fun mkb(@AisTag authId: Long, command: NsiMkbCommand): NsiMkbAnswer

    @AisCommand("12cf09ce-be54-4bbe-967d-6a383e3335e3")
    fun syncNow(@AisTag authId: Long)

    @AisCommand("10ae0a99-b69f-4ae9-90f6-3866d09c48a8")
    fun syncInfo(@AisTag authId: Long): NsiSyncDto

    @AisCommand("8f0969a4-cea5-4609-ba84-ca87289fb2b8")
    fun syncEdit(@AisTag authId: Long, command: NsiSyncDto): NsiSyncDto
}