package aisexpert.backend.ais

import aisexpert.backend.spring.AisCommand
import aisexpert.backend.spring.AisService
import aisexpert.backend.spring.AisTag
import java.time.OffsetDateTime

enum class ReportFedExecStatus {
    UNDEFINED,
    CREATING,
    SUCCESS,
    FAILED
}

data class ReportFedDto(
    val id: String,
    val taskId: String,
    val userId: String?,
    val scoreId: String,
    val name: String,
    val createDate: OffsetDateTime,
    val period: TimeRange,
    val xmlData: String,
    val isPeriodic: Boolean,
    val isCorrection: Boolean,
    val execStatus: ReportFedExecStatus,
    val scoreName: String,
    val orderNum: Int,
    val progressCurrent: Int,
    val progressTotal: Int
)

data class ReportFedFilter(
    val id: String? = null,
    val userId: String? = null,
    val name: String? = null,
    val createDate: TimeRange = TimeRange(),
    val dataPeriod: TimeRange = TimeRange(),
    val scoreId: String? = null
)

data class TaskReportFedCreateCommand(
    val userId: String,
    val scoreId: String,
    val isCorrection: Boolean,
    val period: TimeRange,
    val orderNum: Int,

    // лишние поля
    val name: String = ""
)

data class ReportFedEditCommand(
    val id: String,
    val userId: String,
    val name: String
)

data class ReportFedDeleteCommand(
    val id: String,
    val userId: String
)

data class ReportFedInfoCommand(
    val id: String,
    val userId: String?
)

data class ReportFedListCommand(
    val filter: ReportFedFilter,
    val paging: PagingRequest,
    val items: List<Any> = emptyList()
)

data class ReportFedListAnswer(
    val paging: PagingResponse,
    val items: List<ReportFedDto>
)

data class TaskReportFedDto(
    val isEnabled: Boolean,
    val runDateTime: OffsetDateTime,
    val nextDateTime: OffsetDateTime,
    val fomsCode: String,
    val storeDir: String,
    val parentId: String,
    val parentName: String
)

data class ReportFedNameDto(
    val rpeIndex: Int,
    val rpesIndex: Int
)

@AisService
interface AisReportFedService {
    @AisCommand("9b3765ab-0a25-4ab8-a321-fbddad7aaff7")
    fun create(@AisTag authId: Long, command: TaskReportFedCreateCommand): ReportFedDto

    @AisCommand("f93ac937-acc1-49c7-8cc4-8f48d6d087cc")
    fun edit(@AisTag authId: Long, command: ReportFedEditCommand)

    @AisCommand("546957c0-18ac-48af-ac80-0dfef5f56fa0")
    fun delete(@AisTag authId: Long, command: ReportFedDeleteCommand)

    @AisCommand("6c984825-53fb-4c62-812e-36fdab12e6b2")
    fun info(@AisTag authId: Long, command: ReportFedInfoCommand): ReportFedDto

    @AisCommand("a62a1c48-7d6c-47b6-b380-8ea4be0c19c4")
    fun list(@AisTag authId: Long, command: ReportFedListCommand): ReportFedListAnswer

    @AisCommand("8c63c898-6d92-4294-bf74-0dc588e6e0e5")
    fun periodicSend(@AisTag authId: Long)

    @AisCommand("7f1fe59f-5259-4afe-820e-34ec6bbf6aaa")
    fun periodicInfo(@AisTag authId: Long): TaskReportFedDto

    @AisCommand("7d8b30c8-45b7-40a4-9766-363fe9d63ec5")
    fun periodicEdit(@AisTag authId: Long, command: TaskReportFedDto)

    @AisCommand("04f50670-5536-4634-ba5c-b5588d4580de")
    fun name(@AisTag authId: Long): ReportFedNameDto
}