package aisexpert.backend.ais

import aisexpert.backend.spring.AisCommand
import aisexpert.backend.spring.AisService
import aisexpert.backend.spring.AisTag
import java.time.OffsetDateTime

enum class ReportType {
    UNDEFINED,
    LPU,
    MKB,
    VIDMP,
    MED_PROFILE,
}

enum class RangingType {
    UNDEFINED,
    MEE_SCORES,
    MEE_RISK,
    EKMP_SCORES,
    EKMP_RISK,
}

enum class PresentType {
    UNDEFINED,
    CIRCLE,
    LINE,
    TABLE,
}

enum class SortOrder {
    DESCENDING,
    ASCENDING
}

data class ReportFilter(
    val id: String? = null,
    val userId: String? = null,
    val name: String = "",
    val type: ReportType = ReportType.UNDEFINED,
    val createDate: TimeRange = TimeRange(),
    val dataPeriod: TimeRange = TimeRange(),
    val scoreId: String? = null
)

enum class ReportExecStatus {
    UNDEFINED,
    CREATING,
    SUCCESS,
    FAILED,
}

data class ReportDto(
    val id: String,
    val taskId: String?,
    val taskName: String?,
    val userId: String?,
    val scoreId: String,
    val scoreName: String,
    val type: ReportType,
    val name: String,
    val createDate: OffsetDateTime,
    val period: TimeRange,
    val lpu: String,
    val mkb: String,
    val vidmp: String,
    val medProfile: String,
    val threshold: Double,
    val recordCount: Int,
    val ranging: RangingType,
    val present: PresentType,
    val sort: SortOrder,
    val execStatus: ReportExecStatus
)

data class ReportListCommand(
    val filter: ReportFilter,
    val paging: PagingRequest,

    // лишние поля
    val items: List<Any> = emptyList()
)

data class ReportListAnswer(
    val items: List<ReportDto>,
    val paging: PagingResponse
)

data class ReportInfoCommand(
    val id: String,
    val userId: String?
)

data class ReportDataCommand(
    val reportId: String,
    val userId: String,
    val reportSort: SortOrder,

    // лишние поля
    val items: List<Any> = emptyList()
)

data class ReportDataItem(
    val name: String,
    val code: String,
    val value: Double,
    val nameLpu: String,
    val codeLpu: String
)

data class ReportDataAnswer(
    val items: List<ReportDataItem>
)

data class TaskReportCreateCommand(
    val userId: String,
    val scoreId: String,
    val type: ReportType,
    val name: String,
    val period: TimeRange,
    val lpu: String,
    val mkb: String,
    val vidmp: String,
    val medProfile: String,
    val threshold: Double,
    val ranging: RangingType,
    val present: PresentType,
    val sort: SortOrder,
    val recordCount: Int,

    // лишние поля
    val id: String = "",
    val taskId: String = "",
    val createDate: OffsetDateTime? = null,
    val scoreName: String = "",
    val taskName: String = "",
    val execStatus: ReportExecStatus = ReportExecStatus.UNDEFINED
)

data class ReportEditCommand(
    val id: String,
    val userId: String,
    val name: String
)

data class ReportDeleteCommand(
    val id: String,
    val userId: String
)

@AisService
interface AisReportService {
    @AisCommand("c9dbbd69-e70f-4123-910a-886863b639e9")
    fun list(@AisTag authId: Long, command: ReportListCommand): ReportListAnswer

    @AisCommand("9dec65db-9e82-4651-a0d0-4cd35d53b6f6")
    fun info(@AisTag authId: Long, command: ReportInfoCommand): ReportDto

    @AisCommand("7091cd69-1a27-4c13-b4c1-720064300559")
    fun data(@AisTag authId: Long, command: ReportDataCommand): ReportDataAnswer

    @AisCommand("4e61d479-100d-4c72-be13-2c359d819389")
    fun edit(@AisTag authId: Long, command: ReportEditCommand)

    @AisCommand("6c62b4fb-308f-43ea-b198-8047311f64ca")
    fun delete(@AisTag authId: Long, command: ReportDeleteCommand)

    @AisCommand("147b9b31-c4a5-468f-ae5d-b930f9cfc1d1")
    fun createTask(@AisTag authId: Long, command: TaskReportCreateCommand): ReportDto
}