package aisexpert.backend.ais

import aisexpert.backend.spring.AisCommand
import aisexpert.backend.spring.AisService
import aisexpert.backend.spring.AisTag

enum class ZoneRight {
    NONE,
    READ,
    WRITE,
}

data class AisRole(
    val id: String,
    val name: String,
    val canLearnModel: ZoneRight,
    val canApplyModel: ZoneRight,
    val canRWReport: ZoneRight,
    val canMonitoring: ZoneRight,
    val canReportFed: ZoneRight,
    val isDefault: Boolean,
    val userCount: Int
)

data class RoleListCommand(
    val items: List<Any>
)

data class RoleListAnswer(
    val items: List<AisRole>
)

data class DeleteRoleCommand(
    val id: String
)

data class AssignRoleCommand(
    val groupId: String,
    val userId: String
)

data class RoleInfoCommand(
    val id: String
)

@AisService
interface AisRoleService {
    @AisCommand(type = "ee9f9ffd-62a7-4bf3-87bf-02644a99c260")
    fun list(@AisTag authId: Long, command: RoleListCommand): RoleListAnswer

    @AisCommand(type = "5fc81e1e-2b4d-43c0-983e-8e218ff9e8f9")
    fun add(@AisTag authId: Long, role: AisRole): AisRole

    @AisCommand(type = "02118def-10e5-4fca-b492-63cf5f62a1d9")
    fun update(@AisTag authId: Long, role: AisRole): AisRole

    @AisCommand(type = "b5bcfc10-40eb-4b99-ac3e-44e4377944eb")
    fun delete(@AisTag authId: Long, command: DeleteRoleCommand)

    @AisCommand(type = "842876d0-3ee0-4c56-a125-3e715e40c1d2")
    fun assign(@AisTag authId: Long, command: AssignRoleCommand)

    @AisCommand(type = "47afc108-ff2e-45d4-86f8-0b6292f6c358")
    fun info(@AisTag authId: Long, command: RoleInfoCommand): AisRole
}