package aisexpert.backend.ais

import aisexpert.backend.spring.AisCommand
import aisexpert.backend.spring.AisService
import aisexpert.backend.spring.AisTag
import java.time.OffsetDateTime

enum class SendScoreStatus {
    UNDEFINED,
    CREATED,
    NeedSend,
    IsSent,
}

data class ScoreDto(
    val id: String,
    val userId: String?,
    val name: String,
    val taskId: String?,
    val taskName: String?,
    val modelId: String?,
    val modelName: String?,
    val description: String,
    val period: TimeRange,
    val periodReal: TimeRange,
    val createDate: OffsetDateTime?,
    val isPublic: Boolean,
    val sendStatus: SendScoreStatus,
    val isPeriodic: Boolean,
    val isArchive: Boolean
)

data class ScoreEditCommand(
    val id: String,
    val userId: String?,
    val name: String,
    val description: String,
    val isPublic: Boolean
)

data class ScoreDeleteCommand(
    val id: String,
    val userId: String,
    val force: Boolean
)

data class ScoreInfoCommand(
    val id: String,
    val userId: String?
)

data class ScoreFilter(
    val id: String? = null,
    val taskId: String? = null,
    val userId: String? = null,
    val name: String = "",
    val createDate: TimeRange = TimeRange(),
    val dataPeriod: TimeRange = TimeRange(),
    val modelId: String? = null,
    val show: ShowFilter = ShowFilter.SELF,
    val otherUsers: List<String> = emptyList(),
    val archive: ArchiveFilter = ArchiveFilter.NO
)

data class ScoreListCommand(
    val filter: ScoreFilter = ScoreFilter(),
    val paging: PagingRequest = PagingRequest(),

    // лишние поля
    val items: List<Any> = emptyList()
)

data class ScoreListAnswer(
    val items: List<ScoreDto>
)

data class NeedSendScoreCommand(
    val id: String,
    val userId: String?
)

@AisService
interface AisScoreService {
    @AisCommand("8ec320fa-73f9-4ddf-b535-c2bdb5837da0")
    fun edit(@AisTag authId: Long, command: ScoreEditCommand)

    @AisCommand("7c9f6b60-8ef2-4e72-85da-dde4eb66c37b")
    fun delete(@AisTag authId: Long, command: ScoreDeleteCommand)

    @AisCommand("71253bcc-5b18-487a-a9ef-0a06acdb1bca")
    fun info(@AisTag authId: Long, command: ScoreInfoCommand): ScoreDto

    @AisCommand("d7fc2b29-8c9a-4d84-bb72-ad005ac3dffe")
    fun list(@AisTag authId: Long, command: ScoreListCommand): ScoreListAnswer

    @AisCommand("848157cb-9be1-4fca-974a-b95fdf6c9db6")
    fun send(@AisTag authId: Long, command: NeedSendScoreCommand)
}