package aisexpert.backend.ais

import aisexpert.backend.spring.AisCommand
import aisexpert.backend.spring.AisService
import aisexpert.backend.spring.AisTag

data class SupervisingHardItem(
    val system: Int,
    val process: Int,
    val total: Int
)

data class SupervisingHardwareDto(
    val cpu: SupervisingHardItem,
    val ram: SupervisingHardItem,
    val hdd: SupervisingHardItem,
    val processName: String,
    val PID: Int,
    val nThreads: Int,
    val cpuMaxCoreTemp: Double
)

data class SupervisingSoftItem(
    val modelCount: Int,
    val scoreCount: Int,
    val reportCount: Int
)

data class SupervisingSoftwareDto(
    val inWork: SupervisingSoftItem,
    val inDeferred: SupervisingSoftItem,
    val errorCount: Int,
    val fomsIsActive: Boolean,
    val activeUserCount: Int = 0
)

data class SupervisingDto(
    val hardware: SupervisingHardwareDto,
    val software: SupervisingSoftwareDto
)

data class SupervisingThresholdDto(
    val warn: Int,
    val crit: Int
)

data class SupervisingThresholdsDto(
    val cpu: SupervisingThresholdDto,
    val ram: SupervisingThresholdDto,
    val hdd: SupervisingThresholdDto,
    val cputmp: SupervisingThresholdDto
)

@AisService
interface AisSupervisingService {
    @AisCommand("641fd153-22e4-4959-9e6b-889d6cea3181")
    fun get(@AisTag authId: Long): SupervisingDto

    @AisCommand("c4f71462-1b05-43b4-a9b3-ccca214b460e")
    fun getThresholds(@AisTag authId: Long): SupervisingThresholdsDto

    @AisCommand("e6fbdc6d-bd88-4a48-b4e8-10e37e90b31b")
    fun editThresholds(@AisTag authId: Long, command: SupervisingThresholdsDto): SupervisingThresholdsDto
}