package aisexpert.backend.ais

import aisexpert.backend.spring.AisCommand
import aisexpert.backend.spring.AisService
import aisexpert.backend.spring.AisTag
import java.time.OffsetDateTime

data class SyncDataDto(
    val taskId: String,
    val isEnabled: Boolean,
    val runDateTime: OffsetDateTime,
    val nextDateTime: OffsetDateTime,
    val taskExecStatus: TaskExecStatus,
    val attemptLimit: Int,
    val attemptInterval: Int,
    val relPeriodBegin: Short,
    val relPeriodDuration: Short,
    val current: Int,
    val total: Int
)

data class SyncDataEditCommand(
    val isEnabled: Boolean,
    val nextDateTime: OffsetDateTime,
    val runDateTime: OffsetDateTime,
    val attemptLimit: Int,
    val attemptInterval: Int,
    val relPeriodBegin: Short,
    val relPeriodDuration: Short
)

@AisService
interface AisSyncDataService {
    @AisCommand(type = "7aadf7c4-b689-4198-b994-aa52f9742283")
    fun now(@AisTag authId: Long)

    @AisCommand(type = "8d80f7e0-25d0-4aba-9bcf-73ec8d529fcd")
    fun info(@AisTag authId: Long): SyncDataDto

    @AisCommand(type = "254c0f87-359a-4657-9092-d4e653dae348")
    fun edit(@AisTag authId: Long, command: SyncDataEditCommand)
}