package aisexpert.backend.ais

import aisexpert.backend.spring.AisCommand
import aisexpert.backend.spring.AisService
import aisexpert.backend.spring.AisTag
import java.time.OffsetDateTime

data class TaskModelDto(
    // Task
    val id: String,
    val userId: String?,
    val parentId: String?,
    val parentName: String?,
    val name: String,
    val description: String,
    val createDate: OffsetDateTime,
    val runDateTime: OffsetDateTime,
    val regularityMonth: Int,
    val regularityDay: Int,
    val regularityHour: Int,
    val nextDateTime: OffsetDateTime?,
    val attemptLimit: Int,
    val attemptInterval: Int,
    val attemptCounter: Int,
    val isEnabled: Boolean,
    val execStatus: TaskExecStatus,
    val progressCurrent: Int,
    val progressTotal: Int,
    val waitPosition: Int,
    val runChildTask: Boolean,
    val skipSync: Boolean,

    // TaskModel
    val period: TimeRange,
    val relPeriodBegin: Short,
    val relPeriodDuration: Short,
    val isPublic: Boolean,

    // лишние поля
    val modelId: String? = "",
    val modelName: String? = "",
    val nextRunTime: OffsetDateTime? = null
)

data class TaskModelCreateCommand(
    // Task
    val userId: String,
    val parentId: String?,
    val name: String,
    val description: String,
    val regularityMonth: Int,
    val regularityDay: Int,
    val regularityHour: Int,
    val attemptLimit: Int,
    val attemptInterval: Int,
    val isEnabled: Boolean,
    val execStatus: TaskExecStatus,
    val runDateTime: OffsetDateTime,
    val runChildTask: Boolean,
    val skipSync: Boolean,

    // TaskModel
    val period: TimeRange,
    val relPeriodBegin: Short,
    val relPeriodDuration: Short,
    val isPublic: Boolean,

    // лишние поля
    val id: String = "",
    val createDate: OffsetDateTime? = null,
    val nextRunTime: OffsetDateTime? = null,
    val attemptCounter: Int = 0,
    val modelId: String = "",
    val progressCurrent: Int = 0,
    val progressTotal: Int = 0,
    val parentName: String = "",
    val modelName: String = ""
)

data class TaskModelDeleteCommand(
    val taskId: String,
    val userId: String
)

data class TaskModelInfoCommand(
    val taskId: String,
    val userId: String
)

data class TaskModelListCommand(
    val filter: TaskFilter,

    // лишние поля
    val items: List<Any> = emptyList()
)

data class TaskModelListAnswer(
    val items: List<TaskModelDto>
)

@AisService
interface AisTaskModelService {
    @AisCommand("50d9cc3e-c54e-42dc-9ca9-af740764d489")
    fun create(@AisTag authId: Long, command: TaskModelCreateCommand) : TaskModelDto

    @AisCommand("2a3e45d9-42b5-4861-8ddc-9b0bc8538743")
    fun edit(@AisTag authId: Long, command: TaskModelDto)

    @AisCommand("7dfebaa2-79b2-44d0-9654-3969842484b1")
    fun delete(@AisTag authId: Long, command: TaskModelDeleteCommand)

    @AisCommand("33263c34-4afb-4f85-b4fb-67f49933428a")
    fun info(@AisTag authId: Long, command: TaskModelInfoCommand): TaskModelDto

    @AisCommand("e59db341-1dfb-48ad-a2ad-8ad48a1f85f3")
    fun list(@AisTag authId: Long, command: TaskModelListCommand): TaskModelListAnswer
}