package aisexpert.backend.ais

import aisexpert.backend.spring.AisCommand
import aisexpert.backend.spring.AisService
import aisexpert.backend.spring.AisTag
import java.time.OffsetDateTime

data class TaskScoreDto(
    // Task
    val id: String,
    val userId: String?,
    val parentId: String?,
    val parentName: String?,
    val name: String,
    val description: String,
    val createDate: OffsetDateTime,
    val runDateTime: OffsetDateTime,
    val regularityMonth: Int,
    val regularityDay: Int,
    val regularityHour: Int,
    val nextDateTime: OffsetDateTime?,
    val attemptLimit: Int,
    val attemptInterval: Int,
    val attemptCounter: Int,
    val isEnabled: Boolean,
    val execStatus: TaskExecStatus,
    val progressCurrent: Int,
    val progressTotal: Int,
    val waitPosition: Int,
    val runChildTask: Boolean,
    val skipSync: Boolean,

    // TaskScore
    val modelId: String?,
    val modelName: String?,
    val period: TimeRange,
    val relPeriodBegin: Short,
    val relPeriodDuration: Short,
    val isPublic: Boolean,
    val nextRunTime: OffsetDateTime? = null
)

data class TaskScoreCreateCommand(
    // Task
    val userId: String,
    val parentId: String?,
    val name: String,
    val description: String,
    val regularityMonth: Int,
    val regularityDay: Int,
    val regularityHour: Int,
    val attemptLimit: Int,
    val attemptInterval: Int,
    val isEnabled: Boolean,
    val execStatus: TaskExecStatus,
    val runDateTime: OffsetDateTime,
    val runChildTask: Boolean,
    val skipSync: Boolean,

    // TaskScore
    val modelId: String?,
    val period: TimeRange,
    val relPeriodBegin: Short,
    val relPeriodDuration: Short,
    val isPublic: Boolean,

    // лишние поля
    val id: String = "",
    val createDate: OffsetDateTime? = null,
    val nextRunTime: OffsetDateTime? = null,
    val attemptCounter: Int = 0,
    val progressCurrent: Int = 0,
    val progressTotal: Int = 0,
    val parentName: String = "",
    val modelName: String = ""
)

data class TaskScoreDeleteCommand(
    val taskId: String,
    val userId: String
)

data class TaskScoreInfoCommand(
    val taskId: String,
    val userId: String
)

data class TaskScoreListCommand(
    val filter: TaskFilter,

    // лишние поля
    val items: List<Any> = emptyList()
)

data class TaskScoreListAnswer(
    val items: List<TaskScoreDto>
)

@AisService
interface AisTaskScoreService {
    @AisCommand("b87fd1ab-663e-4586-ab38-07a2d3de675c")
    fun create(@AisTag authId: Long, command: TaskScoreCreateCommand) : TaskScoreDto

    @AisCommand("30545d4e-a83f-4b4a-b4ca-2c7321c50e3f")
    fun edit(@AisTag authId: Long, command: TaskScoreDto)

    @AisCommand("3bf9ccd5-b1e7-4f73-a47f-5043fceb1aad")
    fun delete(@AisTag authId: Long, command: TaskScoreDeleteCommand)

    @AisCommand("90a04054-39ed-4601-ae89-b8f4c11f5b9e")
    fun info(@AisTag authId: Long, command: TaskScoreInfoCommand): TaskScoreDto

    @AisCommand("5c0210ab-cc1e-4704-b747-03922dc3e27f")
    fun list(@AisTag authId: Long, command: TaskScoreListCommand): TaskScoreListAnswer
}