package aisexpert.backend.ais

import aisexpert.backend.spring.AisCommand
import aisexpert.backend.spring.AisService
import aisexpert.backend.spring.AisTag
import java.time.OffsetDateTime

const val TASK_ATTEMPT_LIMIT = 5
const val TASK_ATTEMPT_INTERVAL = 15

enum class TaskMode {
    ALL,
    ONE_TIME,
    PERIODIC
}

enum class TaskExecStatus {
    NOT_RUN,
    RUNNING,
    SUCCESS,
    ATTEMPT,
    FAILED,
    DEFERRED,
    INTERRUPTED,
    WAIT_SYNC
}

enum class TaskType {
    UNDEFINED,
    SYNC_DATA,
    SYNC_PLAN,
    SEND_SCORE,
    LEARN_MODEL,
    SCORE_CALC,
    CREATE_REPORT,
    CREATE_REPORT_FED,
    REPORT_FED,
    SYNC_NSI,
}

data class TaskFilter(
    val id: String? = null,
    val userId: String? = null,
    val mode: TaskMode = TaskMode.ALL,
    val modelId: String? = null,
    val parentId: String? = null,
    val showOtherUsers: Boolean = false
)

data class TaskProgress(
    val taskType: TaskType,
    val taskId: String,
    val current: Int,
    val total: Int,
    val taskName: String,
    val taskDescript: String,
    val taskCreateDate: OffsetDateTime,
    val taskExecStatus: TaskExecStatus,
    val userId: String?,
    val isPeriodic: Boolean,
    val waitPosition: Int
)

data class TaskContentCreate(
    val taskType: TaskType,
    val taskId: String,
    val contentId: String,
    val userId: String?,
    val isPeriodic: Boolean
)

data class TaskStartNowCommand(
    val taskId: String,
    val userId: String
)

data class TaskInterruptCommand(
    val taskId: String,
    val taskType: TaskType,
    val userId: String
)

data class SyncProgressCommand(
    // лишние поля
    val items: List<Any> = emptyList()
)

data class SyncInfo(
    val taskId: String,
    val userId: String?,
    val taskName: String,
    val taskType: TaskType,
    val syncStatus: Boolean,
    val current: Int,
    val total: Int
)

data class SyncProgressAnswer(
    val items: List<SyncInfo>
)

@AisService
interface AisTaskService {
    @AisCommand("3088861b-f6ff-456f-9c6c-0325344898c2")
    fun startNow(@AisTag authId: Long, command: TaskStartNowCommand)

    @AisCommand("903ccdae-443f-4aaa-89d2-6eb4f787ebb3")
    fun interrupt(@AisTag authId: Long, command: TaskInterruptCommand)

    @AisCommand("cd03f508-6098-4ad3-a758-7ec4bb632cf8")
    fun syncProgress(@AisTag authId: Long, command: SyncProgressCommand): SyncProgressAnswer
}