package aisexpert.backend.ais

import aisexpert.backend.spring.AisCommand
import aisexpert.backend.spring.AisService
import aisexpert.backend.spring.AisTag
import aisexpert.backend.spring.UnsignedLongDeserializer
import com.fasterxml.jackson.databind.annotation.JsonDeserialize

data class AisUser(
    val id: String,
    val login: String,
    val name: String,
    val isActive: Boolean,
    val isValid: Boolean,
    val isAdmin: Boolean,
    val groupId: String?
)

data class UserListAnswer(
    val items: List<AisUser>
)

data class UserAuthCommand(
    val login: String,
    val password: String,

    // лишние поля
    val name: String = "",
    val sid: String = "",
    val id: String = "",
    val hashId: Long = 0,
    val isAdmin: Boolean = false
)

data class UserAuthAnswer(
    val name: String,
    val id: String,
    val isAdmin: Boolean,

    @JsonDeserialize(using = UnsignedLongDeserializer::class)
    val hashId: Long
)

data class UserActiveSetCommand(
    val id: String,
    val value: Boolean
)

data class UserListCommand(
    val filterByLogin: String = "",
    val items: List<Any> = emptyList()
)

data class UserInfoCommand(
    val id: String
)

@AisService
interface AisUserService {
    @AisCommand(type = "fc7f12a8-9643-4e81-9d27-53b99c19d319")
    fun userAuth(command: UserAuthCommand): UserAuthAnswer

    @AisCommand(type = "481a49e4-e970-4748-9c3d-5e131a4a08e7")
    fun userLogout(@AisTag authId: Long)

    @AisCommand(type = "2fa92c5d-7f0a-44ca-9dcc-c10c9d5c60d3")
    fun list(@AisTag authId: Long, command: UserListCommand): UserListAnswer

    @AisCommand(type = "ef443931-fceb-497c-89cf-0156aa98a057")
    fun userActiveSet(@AisTag authId: Long, command: UserActiveSetCommand)

    @AisCommand(type = "56f0f673-b93e-470d-9325-8e4a64afdc3e")
    fun userInfo(command: UserInfoCommand): AisUser
}