package aisexpert.backend.ais

import aisexpert.backend.spring.AisCommand
import aisexpert.backend.spring.AisService
import aisexpert.backend.spring.AisTag

data class XgbInfoCommand(
    val id: String?
)

data class XgbParam(
    val name: String,
    val value: String,
    val enabled: Boolean
)

data class XgbDto(
    val id: String?,
    val items: List<XgbParam>
)

data class XgbEditCommand(
    val id: String?,
    val items: List<XgbParam>
)

@AisService
interface AisXgbService {
    @AisCommand("16f55bb2-ecea-406e-8569-cf64ec545e2e")
    fun info(@AisTag authId: Long, command: XgbInfoCommand): XgbDto

    @AisCommand("5d199423-be4d-49a3-8687-8a7e1fdc9a2a")
    fun edit(@AisTag authId: Long, command: XgbEditCommand)
}