package aisexpert.backend.ais

import org.springframework.http.HttpStatus
import org.springframework.http.HttpStatus.*

enum class AisErrorCode(val code: String, val status: HttpStatus, val message: String) {
    FAILED_USER_AUTH("2e3eb742-2dbe-48f6-9e2b-d7c6bd0eb2ec", UNAUTHORIZED, "Не удалось выполнить аутентификацию пользователя"),
    USER_IS_INACTIVE("446dcb56-60bc-4f8e-8fdb-9429d0774f21", UNAUTHORIZED, "Пользователь не активен"),
    USER_NOT_FOUND("a3806b79-4a15-44c9-ad0b-738e84a4093c", NOT_FOUND, "Пользователь не найден"),

    REPORT_NOT_FOUND("5d27d4b4-c395-49c0-a8b2-dd48df2cf7b3", NOT_FOUND, "Отчёт не найден"),
    NEED_ADMIN_PRIVILEGES("3b2b8f38-398b-480e-a4b3-0498dec23d7f", FORBIDDEN, "Необходимы права администратора"),

    GROUP_NOT_FOUND("48719eab-415e-49c2-92c6-c6bb2124c591", NOT_FOUND, "Группа не найдена"),
    DELETE_GROUP_WITH_USERS("eb9c378b-3888-4884-b0df-faf13d7739c6", BAD_REQUEST, "Нельзя удалить группу с пользователями"),
    DELETE_DEFAULT_GROUP("5abe9110-93aa-475c-a573-f3ce6f06247b", BAD_REQUEST, "Нельзя удалить группу по-умолчанию"),

    TASK_NOT_FOUND("d9a76e6e-c8a1-4217-b8e1-0f7262ecebca", NOT_FOUND, "Задача не найдена"),
    TASK_ALREADY_RUNNING("3d61e522-5e40-4a96-88dc-a49384c6b44a", BAD_REQUEST, "Задача уже запущена"),
    DELETE_RUNNING_TASK("7b656a86-90d5-4d5b-a106-2f5772a4fcbf", BAD_REQUEST, "Нельзя удалить запущенную задачу"),
    SYNC_DATA_TASK_NOT_FOUND("d4ecb9f5-2b77-49a0-9a07-e06d7b06582c", NOT_FOUND, "Задача синхронизации данных не найдена"),
    LEARN_MODEL_TASK_NOT_FOUND("9f11994b-2bc7-465d-af75-1ccfebfa1c04", NOT_FOUND, "Задача обучения не найдена"),
    SCORE_CALC_TASK_NOT_FOUND("3746b075-6366-4c30-a8ed-16d3ca370808", NOT_FOUND, "Задача применения не найдена"),

    LEARN_MODEL_NOT_FOUND("0a1cc217-d071-42d8-99da-df70877fe4c2", NOT_FOUND, "Модель не найдена"),
    SCORE_CALC_NOT_FOUND("ae441a99-a1e3-4e62-bf8a-2c15210004ec", NOT_FOUND, "Применение не найдено"),
}