package aisexpert.backend.entity

import org.springframework.security.core.Authentication
import org.springframework.security.core.GrantedAuthority
import java.time.OffsetDateTime
import javax.persistence.*

@Entity
@Table(name = "auth_token", indexes = [
    Index(name = "auth_token_by_hash_id", columnList = "hash_id")
])
data class AuthToken(
    @Id
    @Column(name = "secret")
    val secret: String,

    @Column(name = "user_id")
    val userId: String,

    @Column(name = "user_login")
    val userLogin: String,

    @Column(name = "hash_id")
    val hashId: Long,

    @Column(name = "is_admin", nullable = true)
    val isAdmin: Boolean?,

    @Column(name = "user_agent", nullable = true)
    val userAgent: String?,

    @Column(name = "client_ip", nullable = true)
    val clientIp: String?,

    @Column(name = "created_at", nullable = true)
    val createdAt: OffsetDateTime?,

    @Column(name = "last_active", nullable = true)
    var lastActive: OffsetDateTime?
) : Authentication {
    override fun getAuthorities() = emptyList<GrantedAuthority>()
    override fun setAuthenticated(isAuthenticated: Boolean) = throw IllegalArgumentException()
    override fun getName() = "$userId:$secret"
    override fun getCredentials() = secret
    override fun getPrincipal() = userId
    override fun isAuthenticated() = true
    override fun getDetails() = null
}