package aisexpert.backend.repository

import aisexpert.backend.entity.AuthToken
import org.springframework.data.jpa.repository.Query
import org.springframework.data.repository.CrudRepository

interface AuthTokenRepository : CrudRepository<AuthToken, String> {
    @Query("FROM AuthToken WHERE userId IN ?1")
    fun findByUserIds(userIds: List<String>): List<AuthToken>

    fun findByHashId(hashId: Long): List<AuthToken>
    fun deleteByHashId(hashId: Long)
}