package aisexpert.backend.spring

import org.springframework.web.socket.CloseStatus
import org.springframework.web.socket.WebSocketHandler
import org.springframework.web.socket.WebSocketSession
import org.springframework.web.socket.handler.WebSocketHandlerDecorator

class RegistryWebSocketHandlerDecorator(
    handler: WebSocketHandler,
    private val registry: WebSocketRegistryImpl
) : WebSocketHandlerDecorator(handler) {

    override fun afterConnectionEstablished(session: WebSocketSession) {
        registry.afterConnectionEstablished(session)
        super.afterConnectionEstablished(session)
    }

    override fun afterConnectionClosed(session: WebSocketSession, closeStatus: CloseStatus) {
        registry.afterConnectionClosed(session, closeStatus)
        super.afterConnectionClosed(session, closeStatus)
    }
}