package aisexpert.backend.spring

import com.fasterxml.jackson.core.JsonParser
import com.fasterxml.jackson.databind.DeserializationContext
import com.fasterxml.jackson.databind.JsonDeserializer

class UnsignedLongDeserializer : JsonDeserializer<Long>() {
    override fun deserialize(p: JsonParser, ctxt: DeserializationContext): Long {
        val str = p.readValueAs(String::class.java)
        return java.lang.Long.parseUnsignedLong(str)
    }
}