package aisexpert.backend.spring

import com.fasterxml.jackson.core.JsonGenerator
import com.fasterxml.jackson.databind.JsonSerializer
import com.fasterxml.jackson.databind.SerializerProvider

class UnsignedLongSerializer : JsonSerializer<Long>() {
    override fun serialize(value: Long?, gen: JsonGenerator, serializers: SerializerProvider) {
        if (value != null) {
            gen.writeNumber(java.lang.Long.toUnsignedString(value))
        } else {
            gen.writeNull()
        }
    }
}