package aisexpert.backend.spring

import aisexpert.backend.entity.AuthToken
import aisexpert.backend.web.UserActivityService
import org.slf4j.LoggerFactory
import org.springframework.web.servlet.ModelAndView
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter
import javax.servlet.http.HttpServletRequest
import javax.servlet.http.HttpServletResponse

class UserActivityHandlerInterceptor(
    private val userActivityService: UserActivityService
) : HandlerInterceptorAdapter() {
    private val logger = LoggerFactory.getLogger(UserActivityHandlerInterceptor::class.java)

    override fun postHandle(
        request: HttpServletRequest,
        response: HttpServletResponse,
        handler: Any,
        modelAndView: ModelAndView?
    ) {
        try {
            val principal = request.userPrincipal as? AuthToken ?: return
            userActivityService.updateActivityByTokenSecret(listOf(principal.secret))
        } catch (ex: Throwable) {
            // ошибка здесь не может правильно записаться в ответ, поэтому гасим и выводим в лог
            logger.error("Unexpected error in postHandle", ex)
        }
    }
}