package aisexpert.backend.spring

import com.fasterxml.jackson.databind.ObjectMapper
import java.lang.reflect.Method
import javax.servlet.http.HttpServletResponse

fun aisCommandIndex(method: Method): Int? {
    val commandParams = method.parameters
        .withIndex()
        .filter { it.value.annotations.isEmpty() }
    if (commandParams.size > 1) {
        throw RuntimeException("Method [$method] has more than one body parameters")
    }
    return commandParams.singleOrNull()?.index
}

fun aisTagIndex(method: Method): Int? {
    val tagParams = method.parameters
        .withIndex()
        .filter { it.value.isAnnotationPresent(AisTag::class.java) }
    if (tagParams.size > 1) {
        throw RuntimeException("Method [$method] has more than one @AisTag parameters")
    }
    val tagParam = tagParams.singleOrNull()
    if (tagParam != null && tagParam.value.type != Long::class.javaPrimitiveType) {
        throw RuntimeException("Parameter [${tagParam.value}] has wrong class, must be Long")
    }
    return tagParam?.index
}

fun HttpServletResponse.writeJson(objectMapper: ObjectMapper, value: Any?) {
    contentType = "text/application-json;charset=UTF-8"
    setHeader("Cache-Control", "no-cache")
    objectMapper.writeValue(writer, value)
}