package aisexpert.backend.spring

import aisexpert.backend.web.UserActivityService
import org.springframework.context.annotation.Configuration
import org.springframework.format.FormatterRegistry
import org.springframework.format.datetime.standard.DateTimeFormatterRegistrar
import org.springframework.web.servlet.config.annotation.InterceptorRegistry
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer

@Configuration
class WebConfiguration(
    private val userActivityService: UserActivityService
) : WebMvcConfigurer {
    override fun addFormatters(registry: FormatterRegistry) {
        // нужно, чтобы DateTime поля парсились в query-параметрах
        val registrar = DateTimeFormatterRegistrar()
        registrar.setUseIsoFormat(true)
        registrar.registerFormatters(registry)
    }

    override fun addInterceptors(registry: InterceptorRegistry) {
        // обновляет поле lastActive при каждом запросе от пользователя
        registry.addInterceptor(UserActivityHandlerInterceptor(userActivityService))
    }
}