package aisexpert.backend.spring

import aisexpert.backend.repository.AuthTokenRepository
import com.fasterxml.jackson.databind.ObjectMapper
import org.springframework.context.annotation.Configuration
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity
import org.springframework.security.config.annotation.web.builders.HttpSecurity
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter
import org.springframework.security.config.http.SessionCreationPolicy
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter

@Configuration
@EnableWebSecurity
@EnableGlobalMethodSecurity(prePostEnabled = true, securedEnabled = true)
class WebSecurityConfig(
	private val authTokenRepository: AuthTokenRepository,
	private val objectMapper: ObjectMapper
) : WebSecurityConfigurerAdapter() {
	override fun configure(http: HttpSecurity) {
		http.csrf().disable()

		http.sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS)

		http.addFilterBefore(
			WebSecurityTokenFilter(authTokenRepository, objectMapper),
			UsernamePasswordAuthenticationFilter::class.java
		)

		http.authorizeRequests()
			.antMatchers("/api/auth/login").permitAll()
			.antMatchers("/api/**").authenticated()
			.anyRequest().permitAll()

		http.exceptionHandling()
			.authenticationEntryPoint(Http401UnauthorizedEntryPoint(objectMapper))
	}
}