package aisexpert.backend.spring

import aisexpert.backend.web.WebSocketRegistry
import org.slf4j.LoggerFactory
import org.springframework.stereotype.Component
import org.springframework.web.socket.CloseStatus
import org.springframework.web.socket.WebSocketSession
import java.security.Principal

@Component
class WebSocketRegistryImpl : WebSocketRegistry {
    private val logger = LoggerFactory.getLogger(WebSocketRegistryImpl::class.java)
    private val sessions = ArrayList<WebSocketSession>()

    fun afterConnectionEstablished(session: WebSocketSession) {
        logger.info("WebSocket connected, session = $session")
        synchronized(sessions) {
            sessions.add(session)
        }
    }

    fun afterConnectionClosed(session: WebSocketSession, closeStatus: CloseStatus) {
        logger.info("WebSocket disconnected, session = $session")
        synchronized(sessions) {
            sessions.remove(session)
        }
    }

    override fun disconnectByPrincipal(principal: Principal) {
        logger.info("Closing sessions by principal = $principal")
        synchronized(sessions) {
            val forDisconnect = sessions.filter { it.principal == principal }
            forDisconnect.forEach {
                it.close(CloseStatus.SESSION_NOT_RELIABLE)
            }
        }
    }
}