package aisexpert.backend.utils

import aisexpert.backend.entity.AuthToken
import java.time.Instant
import java.time.OffsetDateTime
import java.time.ZoneId

val zeroOffsetDateTime: OffsetDateTime = OffsetDateTime.ofInstant(Instant.ofEpochMilli(0), ZoneId.of("UTC"))

/** Выборка userId из [AuthToken.getName] */
val String.userId get() = this.split(":")[0]

/** Выборка secret из [AuthToken.getName] */
val String.secret get() = this.split(":")[1]