package aisexpert.backend.web

import aisexpert.backend.spring.AisExceptionHandler
import aisexpert.backend.spring.ErrorBody
import org.springframework.stereotype.Service

interface BatchItem {
    val id: String
}

data class BatchUpdate<T : BatchItem>(
    val updates: List<T> = emptyList(),
    val deletes: List<String> = emptyList(),
    val forceDelete: Boolean = false
)

data class BatchResult<U : Any>(
    val updates: List<U>,
    val deletes: List<String>,
    val errors: Map<String, ErrorBody>
)

@Service
class BatchUpdateService(
    private val exceptionHandler: AisExceptionHandler
) {
    operator fun <T : BatchItem, U : Any> invoke(
        batch: BatchUpdate<T>,
        update: (T) -> U,
        delete: (String) -> Unit
    ): BatchResult<U> {
        val updates = ArrayList<U>()
        val deletes = ArrayList<String>()
        val errors = HashMap<String, ErrorBody>()

        for (item in batch.updates) {
            try {
                updates.add(update(item))
            } catch (ex: Exception) {
                errors[item.id] = exceptionHandler.handle(ex).body!!
            }
        }
        for (id in batch.deletes) {
            try {
                delete(id)
                deletes.add(id)
            } catch (ex: Exception) {
                errors[id] = exceptionHandler.handle(ex).body!!
            }
        }

        return BatchResult(updates, deletes, errors)
    }
}