package aisexpert.backend.web

import aisexpert.backend.ais.AisException
import org.springframework.http.HttpStatus

class HttpException(
    val status: HttpStatus,
    val group: Int = 0,
    val code: String = "",
    message: String? = null,
    cause: Throwable? = null
) : RuntimeException(message, cause) {
    constructor(
        ex: AisException,
        status: HttpStatus = HttpStatus.BAD_REQUEST
    ) : this(
        status = status,
        group = ex.group,
        code = ex.code,
        message = ex.message,
        cause = ex
    )
}