package aisexpert.backend.web

import aisexpert.backend.ais.*
import aisexpert.backend.entity.AuthToken
import org.springframework.web.bind.annotation.*
import java.time.OffsetDateTime

data class NsiSyncUpdateDto(
    val isEnabled: Boolean? = null,
    val nextDateTime: OffsetDateTime? = null,
    val attemptLimit: Int? = null,
    val attemptInterval: Int? = null
)

@RestController
@RequestMapping("/api/nsi")
class NsiController(
    private val aisNsiService: AisNsiService
) {
    @GetMapping("/vidmp")
    fun vidmp(
        authToken: AuthToken,
        @RequestParam scoreId: String
    ): List<NsiVidmp> {
        return aisNsiService.vidmp(authToken.hashId, NsiVidmpCommand(
            scoreId = scoreId
        )).items
    }

    @GetMapping("/med-profile")
    fun medProfile(
        authToken: AuthToken,
        @RequestParam scoreId: String
    ): List<NsiProfile> {
        return aisNsiService.profile(authToken.hashId, NsiProfileCommand(
            scoreId = scoreId
        )).items
    }

    @GetMapping("/lpu")
    fun lpu(
        authToken: AuthToken,
        @RequestParam(required = false) lpuSearch: String? = null,
        @RequestParam(required = false) offset: Int? = null,
        @RequestParam(required = false) limit: Int? = null,
        @RequestParam scoreId: String
    ): List<NsiLpu> {
        val result = aisNsiService.lpu(authToken.hashId, NsiLpuCommand(
            filter = NsiLpuFilter(
                scoreId = scoreId,
                lpuSearch = lpuSearch ?: ""
            )
        ))
        return result.items
    }

    @GetMapping("/mkb")
    fun mkb(
        authToken: AuthToken,
        @RequestParam(required = false) parentId: Int? = null,
        @RequestParam(required = false) mkbSearch: String? = null,
        @RequestParam(required = false) onlyMkbCode: Boolean = false,
        @RequestParam scoreId: String
    ): List<NsiMkb> {
        return aisNsiService.mkb(authToken.hashId, NsiMkbCommand(
            filter = NsiMkbFilter(
                scoreId = scoreId,
                parentId = parentId ?: -1,
                mkbSearch = mkbSearch ?: "",
                onlyMkbCode = onlyMkbCode
            )
        )).items
    }

    @GetMapping("/sync")
    fun syncInfo(authToken: AuthToken): NsiSyncDto {
        return aisNsiService.syncInfo(authToken.hashId)
    }

    @PatchMapping("/sync")
    fun syncUpdate(authToken: AuthToken, @RequestBody data: NsiSyncUpdateDto): NsiSyncDto {
        var sync = aisNsiService.syncInfo(authToken.hashId)
        sync = sync.copy(
            isEnabled = data.isEnabled ?: sync.isEnabled,
            nextDateTime = data.nextDateTime ?: sync.nextDateTime,
            attemptInterval = data.attemptInterval ?: sync.attemptInterval,
            attemptLimit = data.attemptLimit ?: sync.attemptLimit
        )
        aisNsiService.syncEdit(authToken.hashId, sync)
        return sync
    }

    @PostMapping("/sync/send-now")
    fun syncNow(authToken: AuthToken) {
        aisNsiService.syncNow(authToken.hashId)
    }
}