package aisexpert.backend.web

import org.springframework.web.bind.annotation.*

enum class ParameterType {
    STRING,
    SECRET,
    NUMBER
}

data class ParameterDto(
    val key: String,
    val description: String,
    val value: String,
    val type: ParameterType,
    val options: List<String>
)

data class ParameterListDto(
    val parameters: List<ParameterDto>,
    val total: Int
)

data class ParameterUpdateDto(
    val key: String,
    val value: String
)

@RestController
@RequestMapping("/api/parameters")
class ParametersController {
    @GetMapping
    fun list(
        @RequestParam(required = false) search: String? = null,
        @RequestParam(required = false) offset: Int? = null,
        @RequestParam(required = false) limit: Int? = null
    ): ParameterListDto {
        return ParameterListDto(
            parameters = listOf(
                ParameterDto("ldap.url", "Адрес подключения к LDAP", "ldap.mofoms", ParameterType.STRING, emptyList()),
                ParameterDto("ldap.account", "Пользователь для подключения к LDAP", "mofoms.aisexpert", ParameterType.STRING, emptyList()),
                ParameterDto("ldap.groups", "Группы для импорта пользователей. Поиск ведётся по данным группам и всем дочерним", "OU=aisexpert, DC=ldap, DC=mofoms, DC=ru", ParameterType.STRING, emptyList()),
                ParameterDto("ldap.password", "Пароль для подключения к LDAP", "12345678", ParameterType.SECRET, emptyList()),
                ParameterDto("ldap.connection.timeout", "Таймаут для подключения к LDAP", "30", ParameterType.NUMBER, emptyList()),
                ParameterDto("ais.url", "Адрес для подключения к АИС ТФОМС МО", "ais.mofoms.ru", ParameterType.STRING, emptyList()),
                ParameterDto("learning.alarm.action", "Что делать при ошибке обучения", "Уведомлять на E-mail после истечения всех попыток подключения", ParameterType.STRING, listOf("Уведомлять на E-mail после истечения всех попыток подключения", "Ничего не делать", "Перезапустить обучение с параметрами по-умолчанию"))
            ),
            total = 100
        )
    }

    @PatchMapping
    fun update(@RequestBody data: List<ParameterUpdateDto>): List<ParameterDto> {
        TODO()
    }
}