package aisexpert.backend.web

import aisexpert.backend.utils.secret
import org.slf4j.LoggerFactory
import org.springframework.messaging.simp.user.SimpUserRegistry
import org.springframework.scheduling.annotation.Scheduled
import org.springframework.stereotype.Service

@Service
class WebSocketUserActivityService(
    private val userActivityService: UserActivityService,
    private val userRegistry: SimpUserRegistry
) {
    private val logger = LoggerFactory.getLogger(WebSocketUserActivityService::class.java)

    @Scheduled(fixedRate = 60 * 1000)
    fun updateUserActivity() {
        val secrets = userRegistry
            .findSubscriptions { true }
            .map { it.session.user.name.secret }
            .distinct()
        if (secrets.isNotEmpty()) {
            logger.info("Active web socket tokens = $secrets")
            userActivityService.updateActivityByTokenSecret(secrets)
        }
    }
}