package aisexpert.backend

import aisexpert.backend.spring.TOKEN_HEADER_KEY
import aisexpert.backend.web.UserDto
import org.junit.Assert.assertNotNull
import org.junit.Test
import org.springframework.http.client.ClientHttpRequestInterceptor
import org.springframework.web.client.HttpClientErrorException
import org.springframework.web.client.RestClientException
import org.springframework.web.client.RestTemplate
import org.springframework.web.client.postForObject

class AuthTests : ApplicationTests() {
    @Test
    fun testLogin() {
        val response = login("user1", "111")
        assertNotNull(response.token)
    }

    @Test(expected = RestClientException::class)
    fun testLoginFailed() {
        login("test", "test")
    }

    @Test
    fun testLogout() {
        val restTemplate = RestTemplate()
        authorize(restTemplate, "user1", "111")
        restTemplate.postForObject<Any>("$baseUrl/auth/logout")
        expectError<HttpClientErrorException.Forbidden> {
            restTemplate.postForObject<UserDto>("$baseUrl/users/current")
        }
    }

    @Test
    fun testNullToken() {
        val restTemplate = RestTemplate()
        expectError<HttpClientErrorException.Unauthorized> {
            restTemplate.postForObject<UserDto>("$baseUrl/users/current")
        }
    }

    @Test
    fun testBadToken() {
        val restTemplate = RestTemplate()
        restTemplate.interceptors = listOf(
            ClientHttpRequestInterceptor { request, body, execution ->
                request.headers[TOKEN_HEADER_KEY] = "bad-token"
                execution.execute(request, body)
            }
        )
        expectError<HttpClientErrorException.BadRequest> {
            restTemplate.postForObject<UserDto>("$baseUrl/users/current")
        }
    }
}

