package aisexpert.backend

import aisexpert.backend.ais.ZoneRight
import aisexpert.backend.web.*
import org.junit.Assert.assertEquals
import org.junit.Assert.assertTrue
import org.junit.Before
import org.junit.Test
import org.springframework.http.HttpEntity
import org.springframework.http.HttpMethod
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory
import org.springframework.web.client.RestTemplate
import org.springframework.web.client.exchange
import org.springframework.web.client.postForObject

class GroupTests : ApplicationTests() {
    private val restTemplate = RestTemplate(HttpComponentsClientHttpRequestFactory())
    private val userName = "user1"
    private val password = "111"

    @Before
    fun initGroups() {
        authorize(restTemplate, userName, password)
    }

    @Test
    fun testList() {
        val groups = restTemplate.getForObject<List<GroupDto>>("$baseUrl/groups")!!
        assertTrue(groups.isNotEmpty())
    }

    @Test
    fun testCreateUpdateDelete() {
        val data = restTemplate.postForObject<GroupDto>("$baseUrl/groups", GroupCreateDto(
            name = "test",
            zones = GroupZonesDto(
                learn = ZoneRight.WRITE,
                supervising = ZoneRight.READ,
                reports = ZoneRight.NONE,
                apply = ZoneRight.WRITE,
                reportsFed = ZoneRight.WRITE
            )
        ))!!

        try {
            assertEquals(data.name, "test")
            assertEquals(data.zones.learn, ZoneRight.WRITE)
            assertEquals(data.zones.supervising, ZoneRight.READ)
            assertEquals(data.zones.reports, ZoneRight.NONE)
            assertEquals(data.zones.apply, ZoneRight.WRITE)
            assertEquals(data.zones.reportsFed, ZoneRight.WRITE)

            val data2 = restTemplate.getForObject<GroupDto>("$baseUrl/groups/${data.id}")
            assertEquals(data, data2)

            val updated = restTemplate.exchange<BatchResult<GroupDto>>(
                "$baseUrl/groups/update-multiple",
                HttpMethod.PATCH,
                HttpEntity(BatchUpdate(
                    updates = listOf(
                        GroupUpdateDto(
                            id = data.id,
                            name = "test2",
                            zones = GroupZonesUpdateDto(
                                learn = ZoneRight.READ,
                                supervising = ZoneRight.WRITE,
                                reports = ZoneRight.READ,
                                apply = ZoneRight.NONE
                            )
                        )
                    )
                ))
            ).body!!.updates
            assertEquals(updated.size, 1)

            val data3 = restTemplate.getForObject<GroupDto>("$baseUrl/groups/${data.id}")!!
            assertEquals(data3.name, "test2")
            assertEquals(data3.zones.learn, ZoneRight.READ)
            assertEquals(data3.zones.supervising, ZoneRight.WRITE)
            assertEquals(data3.zones.reports, ZoneRight.READ)
            assertEquals(data3.zones.apply, ZoneRight.NONE)
            assertEquals(updated.first(), data3)

        } finally {
            try {
                restTemplate.patchForObject<Any>("$baseUrl/groups/update-multiple", BatchUpdate<GroupUpdateDto>(
                    deletes = listOf(data.id)
                ))
            } catch (ex: Throwable) {
                ex.printStackTrace()
            }
        }
    }
}