package aisexpert.backend

import aisexpert.backend.ais.ModelDto
import aisexpert.backend.web.BatchResult
import aisexpert.backend.web.BatchUpdate
import aisexpert.backend.web.ModelListDto
import aisexpert.backend.web.ModelUpdateDto
import org.junit.Assert.assertEquals
import org.junit.Assert.assertTrue
import org.junit.Before
import org.junit.Test
import org.springframework.web.client.RestTemplate
import org.springframework.web.client.getForObject

class ModelTests : ApplicationTests() {
    lateinit var restTemplate: RestTemplate
    lateinit var token: String

    @Before
    fun authorize() {
        restTemplate = restTemplate()
        token = authorize(restTemplate, "user1", "111").token
    }

    @Test
    fun testGetAll() {
        val result = restTemplate.getForObject<ModelListDto>("$baseUrl/models")!!
        assertTrue(result.items.isNotEmpty())
    }

    @Test
    fun testUpdate() {
        val model = restTemplate.getForObject<ModelListDto>("$baseUrl/models")!!.items.first()

        val newName = "Model name ${System.currentTimeMillis()}"
        val newDescription = "Model description ${System.currentTimeMillis()}"
        val newIsPublic = !model.isPublic

        val updated = restTemplate.patchForObject<BatchResult<ModelDto>>("$baseUrl/models/update-multiple", BatchUpdate(
            updates = listOf(ModelUpdateDto(
                id = model.id,
                name = newName,
                description = newDescription,
                isPublic = newIsPublic
            ))
        ))!!.updates.first()

        assertEquals(newName, updated.name)
        assertEquals(newDescription, updated.description)
        assertEquals(newIsPublic, updated.isPublic)

        val model2 = restTemplate.getForObject<ModelDto>("$baseUrl/models/${model.id}")!!

        assertEquals(newName, model2.name)
        assertEquals(newDescription, model2.description)
        assertEquals(newIsPublic, model2.isPublic)
    }
}