package aisexpert.backend

import aisexpert.backend.ais.NsiLpu
import aisexpert.backend.ais.NsiMkb
import aisexpert.backend.ais.NsiProfile
import aisexpert.backend.ais.NsiVidmp
import aisexpert.backend.web.ScoreListDto
import org.junit.Assert.assertNotEquals
import org.junit.Before
import org.junit.Test
import org.springframework.web.client.RestTemplate

class NsiTests : ApplicationTests() {
    lateinit var restTemplate: RestTemplate

    @Before
    fun authorize() {
        restTemplate = restTemplate()
        authorize(restTemplate, "user1", "111")
    }

    @Test
    fun testLpu() {
        val score = restTemplate
            .getForObject<ScoreListDto>("$baseUrl/scores")!!
            .items
            .first()
        val result = restTemplate.getForObject<List<NsiLpu>>("$baseUrl/nsi/lpu?scoreId=${score.id}")!!
        assertNotEquals(result, emptyList<NsiLpu>())
    }

    @Test
    fun testMkb() {
        val score = restTemplate
            .getForObject<ScoreListDto>("$baseUrl/scores")!!
            .items
            .first()
        val result = restTemplate.getForObject<List<NsiMkb>>("$baseUrl/nsi/mkb?scoreId=${score.id}")!!
        assertNotEquals(result, emptyList<NsiMkb>())
    }

    @Test
    fun testVidmp() {
        val score = restTemplate
            .getForObject<ScoreListDto>("$baseUrl/scores")!!
            .items
            .first()
        val result = restTemplate.getForObject<List<NsiVidmp>>("$baseUrl/nsi/vidmp?scoreId=${score.id}")!!
        assertNotEquals(result, emptyList<NsiVidmp>())
    }

    @Test
    fun testMedProfile() {
        val score = restTemplate
            .getForObject<ScoreListDto>("$baseUrl/scores")!!
            .items
            .first()
        val result = restTemplate.getForObject<List<NsiProfile>>("$baseUrl/nsi/med-profile?scoreId=${score.id}")!!
        assertNotEquals(result, emptyList<NsiProfile>())
    }
}