package aisexpert.backend

import aisexpert.backend.ais.*
import aisexpert.backend.web.*
import org.junit.Assert.assertEquals
import org.junit.Assert.assertTrue
import org.junit.Before
import org.junit.Test
import org.springframework.web.client.RestTemplate
import org.springframework.web.client.postForObject

class ReportTests : ApplicationTests() {
    private lateinit var restTemplate: RestTemplate

    @Before
    fun authorize() {
        restTemplate = restTemplate()
        authorize(restTemplate, "user1", "111")
    }

    @Test
    fun testList() {
        val items = restTemplate.getForObject<ReportListDto>("$baseUrl/reports")!!.items
        assertTrue(items.isNotEmpty())
    }

    @Test
    fun testCreateUpdateDelete() {
        val score = restTemplate.getForObject<ScoreListDto>("$baseUrl/scores")!!
            .items
            .first()

        val data = restTemplate.postForObject<ReportDto>("$baseUrl/reports", ReportCreateDto(
            scoreId = score.id,
            type = ReportType.LPU,
            name = "foo",
            period = score.period,
            lpu = "1",
            mkb = "E2-E3",
            vidmp = "13",
            medProfile = "3",
            threshold = 0.51,
            ranging = RangingType.MEE_RISK,
            sort = SortOrder.DESCENDING,
            present = PresentType.CIRCLE,
            recordCount = 10
        ))!!

        try {
            val newName = "foo ${System.currentTimeMillis()}"

            val updated = restTemplate.patchForObject<BatchResult<ReportDto>>("$baseUrl/reports/update-multiple", BatchUpdate(
                updates = listOf(
                    ReportUpdateDto(
                        id = data.id,
                        name = newName
                    )
                )
            ))!!.updates.first()

            assertEquals(data.id, updated.id)
            assertEquals(newName, updated.name)

            val data2 = restTemplate.getForObject<ReportDto>("$baseUrl/reports/${data.id}")!!
            assertEquals(newName, data2.name)

        } finally {
            restTemplate.patchForObject<BatchResult<ReportDto>>("$baseUrl/reports/update-multiple", BatchUpdate<ReportUpdateDto>(
                deletes = listOf(data.id)
            ))
        }
    }
}