package aisexpert.backend

import aisexpert.backend.ais.ScoreDto
import aisexpert.backend.web.BatchResult
import aisexpert.backend.web.BatchUpdate
import aisexpert.backend.web.ScoreListDto
import aisexpert.backend.web.ScoreUpdateDto
import org.junit.Assert
import org.junit.Assert.assertTrue
import org.junit.Before
import org.junit.Test
import org.springframework.web.client.RestTemplate
import org.springframework.web.client.getForObject

class ScoreTests : ApplicationTests() {
    private lateinit var restTemplate: RestTemplate
    lateinit var token: String

    @Before
    fun authorize() {
        restTemplate = restTemplate()
        token = authorize(restTemplate, "user1", "111").token
    }

    @Test
    fun testGetAll() {
        val result = restTemplate.getForObject<ScoreListDto>("$baseUrl/scores")!!
        assertTrue(result.items.isNotEmpty())
    }

    @Test
    fun testUpdate() {
        val score = restTemplate.getForObject<ScoreListDto>("$baseUrl/scores")!!.items.first()

        val newName = "Score name ${System.currentTimeMillis()}"
        val newDescription = "Score description ${System.currentTimeMillis()}"
        val newIsPublic = !score.isPublic

        val updated = restTemplate.patchForObject<BatchResult<ScoreDto>>("$baseUrl/scores/update-multiple", BatchUpdate(
            updates = listOf(ScoreUpdateDto(
                id = score.id,
                name = newName,
                description = newDescription,
                isPublic = newIsPublic
            ))
        ))!!.updates.first()

        Assert.assertEquals(newName, updated.name)
        Assert.assertEquals(newDescription, updated.description)
        Assert.assertEquals(newIsPublic, updated.isPublic)

        val score2 = restTemplate.getForObject<ScoreDto>("$baseUrl/scores/${score.id}")!!

        Assert.assertEquals(newName, score2.name)
        Assert.assertEquals(newDescription, score2.description)
        Assert.assertEquals(newIsPublic, score2.isPublic)
    }
}