package aisexpert.backend

import aisexpert.backend.ais.SupervisingDto
import aisexpert.backend.ais.ZoneRight
import aisexpert.backend.web.*
import org.junit.Test
import org.springframework.web.client.RestTemplate
import org.springframework.web.client.getForObject
import java.util.concurrent.ExecutionException
import java.util.concurrent.TimeoutException
import javax.websocket.DeploymentException

class SupervisingTests : ApplicationTests() {
    @Test
    fun testGetAll() {
        val restTemplate = RestTemplate()
        authorize(restTemplate, "user1", "111")
        restTemplate.getForObject<SupervisingDto>("$baseUrl/supervising")!!
    }

    @Test
    fun testAdminSubscription() {
        val restTemplate = RestTemplate()
        val token = authorize(restTemplate, "user1", "111").token
        val client = stompClient()
        val session = stompSession(client, token)

        try {
            subscribeForOne<SupervisingDto>(session, USER_QUEUE_SUPERVISING, 3000)
        } finally {
            try {
                session.disconnect()
            } catch (ex: Throwable) {
                ex.printStackTrace()
            }
        }
    }

    @Test
    fun testNonAdminSubscription() {
        val adminRestTemplate = restTemplate()
        val adminToken = authorize(adminRestTemplate, "user1", "111").token

        val user2 = adminRestTemplate.getForObject<UserListDto>("$baseUrl/users")!!
            .items
            .first { it.login == "user2" }
        adminRestTemplate.patchForObject<Any>("$baseUrl/groups/update-multiple", BatchUpdate(
            updates = listOf(
                GroupUpdateDto(
                    id = user2.groupId!!,
                    zones = GroupZonesUpdateDto(
                        supervising = ZoneRight.READ
                    )
                )
            )
        ))

        val adminClient = stompClient()
        val adminSession = stompSession(adminClient, adminToken)
        val adminFuture = subscribeForOneFuture<SupervisingDto>(adminSession, USER_QUEUE_SUPERVISING)

        val restTemplate = RestTemplate()
        val token = authorize(restTemplate, "user2", "222").token
        val client = stompClient()
        val session = stompSession(client, token)

        try {
            subscribeForOne<SupervisingDto>(session, USER_QUEUE_SUPERVISING, 3000)
        } finally {
            try {
                session.disconnect()
                adminSession.disconnect()
                adminFuture.cancel(true)
            } catch (ex: Throwable) {
                ex.printStackTrace()
            }
        }
    }

    @Test
    fun testNoAccessSubscription() {
        val adminRestTemplate = restTemplate()
        val adminToken = authorize(adminRestTemplate, "user1", "111").token

        val user3 = adminRestTemplate.getForObject<UserListDto>("$baseUrl/users")!!
            .items
            .first { it.login == "user3" }
        adminRestTemplate.patchForObject<Any>("$baseUrl/groups/update-multiple", BatchUpdate(
            updates = listOf(
                GroupUpdateDto(
                    id = user3.groupId!!,
                    zones = GroupZonesUpdateDto(
                        supervising = ZoneRight.NONE
                    )
                )
            )
        ))

        val adminClient = stompClient()
        val adminSession = stompSession(adminClient, adminToken)
        val adminFuture = subscribeForOneFuture<SupervisingDto>(adminSession, USER_QUEUE_SUPERVISING)

        val restTemplate = RestTemplate()
        val token = authorize(restTemplate, "user3", "333").token
        val client = stompClient()
        val session = stompSession(client, token)

        try {
            expectError<TimeoutException> {
                subscribeForOne<SupervisingDto>(session, USER_QUEUE_SUPERVISING, 3000)
            }
        } finally {
            try {
                session.disconnect()
                adminSession.disconnect()
                adminFuture.cancel(true)
            } catch (ex: Throwable) {
                ex.printStackTrace()
            }
        }
    }

    @Test(expected = DeploymentException::class)
    fun testSubscriptionUnauthorized() {
        val client = stompClient()
        try {
            stompSession(client, null)
        } catch (ex: ExecutionException) {
            throw ex.cause ?: ex
        }
    }
}