package aisexpert.backend

import aisexpert.backend.ais.TaskModelDto
import aisexpert.backend.ais.TimeRange
import aisexpert.backend.utils.zeroOffsetDateTime
import aisexpert.backend.web.*
import org.junit.Assert.*
import org.junit.Before
import org.junit.Test
import org.springframework.web.client.RestTemplate
import org.springframework.web.client.postForObject
import java.time.OffsetDateTime

class TaskModelTests : ApplicationTests() {
    private lateinit var restTemplate: RestTemplate
    private val userName = "user1"
    private val password = "111"

    @Before
    fun initTaskModels() {
        restTemplate = restTemplate()
        authorize(restTemplate, userName, password)
    }

    @Test
    fun testList() {
        restTemplate.getForObject<List<TaskModelDto>>("$baseUrl/tasks/models")
    }

    @Test
    fun testCreateUpdateDelete() {
        val data = restTemplate.postForObject<TaskModelDto>("$baseUrl/tasks/models", TaskModelCreateDto(
            name = "foo",
            description = "bar",
            regularityMonth = 0,
            regularityDay = 0,
            regularityHour = 0,
            attemptLimit = 5,
            attemptInterval = 15,
            isEnabled = false,
            period = TimeRange(
                begin = OffsetDateTime.parse("2018-02-01T00:00:00+03:00"),
                end = OffsetDateTime.parse("2018-03-01T00:00:00+03:00")
            ),
            relPeriodBegin = 0,
            relPeriodDuration = 0,
            isPublic = false,
            runDateTime = OffsetDateTime.now(),
            skipSync = false
        ))!!

        try {
            assertEquals("foo", data.name)
            assertEquals("bar", data.description)
            assertFalse(data.isEnabled)
            assertFalse(data.isPublic)
            assertNotEquals(data.createDate, zeroOffsetDateTime)

            val updated = restTemplate.patchForObject<BatchResult<TaskModelDto>>("$baseUrl/tasks/models/update-multiple", BatchUpdate(
                updates = listOf(TaskModelUpdateDto(
                    id = data.id,
                    isPublic = true,
                    description = "new desc",
                    name = "new name"
                ))
            ))!!.updates.first()

            assertEquals(data.id, updated.id)
            assertEquals(true, updated.isPublic)
            assertEquals("new name", updated.name)
            assertEquals("new desc", updated.description)

            val data2 = restTemplate.getForObject<TaskModelDto>("$baseUrl/tasks/models/${data.id}")!!
            assertEquals(updated.id, data2.id)
            assertEquals(updated.isPublic, data2.isPublic)
            assertEquals(updated.name, data2.name)
            assertEquals(updated.description, data2.description)

        } finally {
            restTemplate.patchForObject<Any>("$baseUrl/tasks/models/update-multiple", BatchUpdate<TaskModelUpdateDto>(
                deletes = listOf(data.id)
            ))
        }
    }

    @Test
    fun testRunTask() {
        // todo
    }

    @Test
    fun testLog() {
        val task = restTemplate.getForObject<List<TaskModelDto>>("$baseUrl/tasks/models")!!
            .first()

        restTemplate.getForObject<LogDto>("$baseUrl/system/log?limit=10&offset=0&taskId=${task.id}")!!
    }
}