package aisexpert.backend

import aisexpert.backend.web.*
import org.junit.Assert.assertEquals
import org.junit.Assert.assertTrue
import org.junit.Before
import org.junit.Test
import org.springframework.web.client.RestTemplate
import java.util.*

class UserTests : ApplicationTests() {
    private lateinit var restTemplate: RestTemplate
    private val userName = "user1"
    private val password = "111"

    @Before
    fun initUsers() {
        restTemplate = restTemplate()
        authorize(restTemplate, userName, password)
    }

    @Test
    fun testList() {
        val users = restTemplate.getForObject<UserListDto>("$baseUrl/users")!!
        assertTrue(users.items.isNotEmpty())
    }

    @Test
    fun testGetCurrent() {
        restTemplate.getForObject<CurrentUserDto>("$baseUrl/users/current")
    }

    @Test
    fun testUpdate() {
        val groups = restTemplate.getForObject<List<GroupDto>>("$baseUrl/groups")!!

        val data = restTemplate.getForObject<UserListDto>("$baseUrl/users")!!
            .items
            .first { it.login == "user3" }

        val rand = Random(System.currentTimeMillis())
        val newIsActive = !data.isActive
        val newGroupId = groups[rand.nextInt(groups.size)].id

        val updated = restTemplate.patchForObject<BatchResult<UserDto>>("$baseUrl/users/update-multiple", BatchUpdate(
            updates = listOf(UserUpdateDto(
                id = data.id,
                isActive = newIsActive,
                groupId = newGroupId
            ))
        ))!!.updates.first()

        assertEquals(data.id, updated.id)
        assertEquals(newIsActive, updated.isActive)
        assertEquals(newGroupId, updated.groupId)

        val data2 = restTemplate.getForObject<UserListDto>("$baseUrl/users")!!
            .items
            .first { it.login == "user3" }
        assertEquals(newIsActive, data2.isActive)
        assertEquals(newGroupId, data2.groupId)

        restTemplate.patchForObject<BatchResult<UserDto>>("$baseUrl/users/update-multiple", BatchUpdate(
            updates = listOf(UserUpdateDto(
                id = data.id,
                isActive = true,
                groupId = data.groupId
            ))
        ))!!.updates.first()
    }
}