package aisexpert.backend

import org.springframework.core.ParameterizedTypeReference
import org.springframework.http.HttpEntity
import org.springframework.http.HttpMethod
import org.springframework.web.client.RestTemplate

inline fun <reified E> expectError(block: () -> Unit) {
    try {
        block()
        assert(false) { "Expected [${E::class.java.name}], but was no exception" }
    } catch (ex: Throwable) {
        assert(ex is E) { "Expected [${E::class.java.name}], but was $ex" }
    }
}

inline fun <reified T> RestTemplate.getForObject(url: String): T? {
    return this.exchange(url, HttpMethod.GET, null, object : ParameterizedTypeReference<T>() {}).body
}

inline fun <reified T> RestTemplate.patchForObject(url: String, request: Any): T? {
    val requestEntity = HttpEntity(request)
    return this.exchange(url, HttpMethod.PATCH, requestEntity, object : ParameterizedTypeReference<T>() {}).body
}