package aisexpert.backend

import org.junit.Test
import org.springframework.messaging.simp.stomp.ConnectionLostException
import org.springframework.messaging.simp.stomp.StompSession
import org.springframework.messaging.simp.stomp.StompSessionHandlerAdapter
import java.util.concurrent.CompletableFuture
import java.util.concurrent.TimeUnit

class WebSocketTests : ApplicationTests() {
    @Test
    fun testSessionCloseOnTokenRevoke() {
        val token = login("user1", "111").token
        val client = stompClient()
        val future = CompletableFuture<Throwable>()

        val session = stompSession(client, token, object : StompSessionHandlerAdapter() {
            override fun handleTransportError(session: StompSession, exception: Throwable) {
                future.complete(exception)
            }
        })

        try {
            login("user1", "111")
            val ex = future.get(1000, TimeUnit.MILLISECONDS)
            assert(ex is ConnectionLostException)
        } finally {
            try { session.disconnect() } catch (ex: IllegalStateException) {}
        }
    }
}