package aisexpert.backend

import aisexpert.backend.ais.XgbDto
import aisexpert.backend.web.ModelListDto
import org.junit.Assert.assertEquals
import org.junit.Assert.assertTrue
import org.junit.Before
import org.junit.Test
import org.springframework.web.client.RestTemplate

class XgbTests : ApplicationTests() {
    private lateinit var restTemplate: RestTemplate

    @Before
    fun authorize() {
        restTemplate = restTemplate()
        authorize(restTemplate, "user1", "111")
    }

    @Test
    fun testInfo() {
        val xgb = restTemplate.getForObject<XgbDto>("$baseUrl/system/xgb")!!
        assertTrue(xgb.items.isNotEmpty())
    }

    @Test
    fun testModelInfo() {
        val model = restTemplate.getForObject<ModelListDto>("$baseUrl/models")!!
            .items
            .first()
        val xgb = restTemplate.getForObject<XgbDto>("$baseUrl/system/xgb/${model.id}")!!
        assertTrue(xgb.items.isNotEmpty())
    }

    @Test
    fun testEdit() {
        val itemName = "base_score"
        val initialItem = restTemplate.getForObject<XgbDto>("$baseUrl/system/xgb")!!
            .items
            .first { it.name == itemName }

        try {
            val updatedItem = initialItem.copy(value = "0.51", enabled = !initialItem.enabled)
            restTemplate.patchForObject<Any>("$baseUrl/system/xgb", listOf(updatedItem))

            val actualItem = restTemplate.getForObject<XgbDto>("$baseUrl/system/xgb")!!
                .items
                .first { it.name == itemName }

            assertEquals(actualItem.value, updatedItem.value)
            assertEquals(actualItem.enabled, updatedItem.enabled)
        } finally {
            restTemplate.patchForObject<Any>("$baseUrl/system/xgb", listOf(initialItem))
        }
    }
}