# Фронте-енд
## 1. Сборка

Все действия этого раздела выполняются локально.
Инструкция для Ubuntu 16.04 и выше, но может быть выполнена и на других ОС с некоторыми изменениями.

### 1.1. Установка Node.js

Для установки Node.js (версии 10) требуется выполнить:

    cd ~
    curl -sL https://deb.nodesource.com/setup_10.x -o nodesource_setup.sh
    sudo bash nodesource_setup.sh
    sudo apt install nodejs

### 1.2. Сборка проекта

Находясь в дерректории `ais-expert-app`. Первая команда установит зависисмости проекта, вторая соберет проект и поместит интересующие файлы в папку `./dist `:

    npm install
    npm run build

### Локальный запуск (проверка перед разворачиванием)

Для работоспособности локальной версии необходимо подкорректировать файл `ais-expert-app/vue.config.js`. В секции `devServer.proxy` изменить поле `target`:

    ...
    target: 'http://<remote_ip>:80',
    ...

Запуск:

    npm run serve

## 2. Deploy

Действия из этого раздела выполняются на целевой машине.

### 2.1. Установка Nginx

2.1.1 Для установки nginx требуется выполнить:

    sudo apt update
    sudo apt install nginx

2.1.2 Для проверки работоспособности и корректности установки nginx:

    sudo systemctl status nginx

Ожидаемый ответ:

    ● nginx.service - A high performance web server and a reverse proxy server
    Loaded: loaded (/lib/systemd/system/nginx.service; enabled; vendor preset: enabled)
    Active: active (running) since Чт 2019-03-28 10:41:20 MSK; 1min 34s ago
    Main PID: 10917 (nginx)
    CGroup: /system.slice/nginx.service
            ├─10917 nginx: master process /usr/sbin/nginx -g daemon on; master_process on
            ├─10918 nginx: worker process                           
            ├─10919 nginx: worker process                           
            ├─10920 nginx: worker process                           
            ├─10921 nginx: worker process                           
            ├─10922 nginx: worker process                           
            ├─10923 nginx: worker process                           
            ├─10924 nginx: worker process                           
            └─10925 nginx: worker process 

2.1.3 Проверить, что порт 80 не закрыт файерволом (для ubuntu):

    sudo ufw status

### 2.2. Настройка Nginx

2.2.1 Создать файл конфигурации для nginx:

    sudo nano /etc/nginx/sites-available/01-aisexpert.conf

И заполнить его следующим содержимым:

    upstream backend {
        server 127.0.0.1:8080;
    }

    server {
        listen 80;

        location / {
            root   /opt/aisexpert-frontend/dist;
            index  index.html;

            try_files $uri $uri/ /index.html;

            include  /etc/nginx/mime.types;
        }

        location /api/ {
            proxy_set_header X-Forwarded-Host $host:$server_port;
            proxy_set_header X-Forwarded-Server $host;
            proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
            proxy_pass http://backend;
        }

        location /api/websocket {
            proxy_pass http://backend;
            proxy_http_version 1.1;
            proxy_set_header Upgrade $http_upgrade;
            proxy_set_header Connection "upgrade";
        }
    }

Где `127.0.0.1:8080` - Адрес прокси-бекенда по умолчанию
а `/opt/aisexpert-frontend` - Директория для папки `dist`

2.2.2 Для проверки синтаксической корректности конфигурации nginx:

    sudo nginx -t

Ожидаемый результат:

    nginx: the configuration file /etc/nginx/nginx.conf syntax is ok
    nginx: configuration file /etc/nginx/nginx.conf test is successful

2.2.3 Необходимо перенаправить символическую ссылку `/etc/nginx/sites-enabled/default` на созданную конфигурацию:

    sudo rm /etc/nginx/sites-enabled/default
    sudo ln -s /etc/nginx/sites-available/01-aisexpert.conf /etc/nginx/sites-enabled/default

Для проверки:

    sudo nginx -t
    sudo nginx -T

2.2.4 Теперь необходимо поместить папку `dist` (из п. 1.2) в `/opt/aisexpert-frontend`
Для этого требуется подготовить следующую директорию:

    sudo mkdir -p /opt/aisexpert-frontend
    sudo chown -r $USER:$USER /opt/aisexpert-frontend

И скопировать `dist` (c локальной машины на целевую):

    rsync -az --progress dist/ piklab2@10.20.96.79:/opt/aisexpert-frontend/dist --delete-before

где `piklab2@10.20.96.79` имя пользователя и ip адрес удаленной машины

2.2.5 Последний шаг - перезапустить nginx

    sudo nginx -s reload
