#!/bin/sh
# Единственный параметр - имя "ветки" - dev, stage или prod
BRANCHES="dev master"  # stage prod
branch=$1

GREEN='\033[0;32m'
RED='\033[0;31m'
NC='\033[0m'

if echo $BRANCHES | grep -w $branch > /dev/null; then
    printf "Deploy to branch ${RED}'${branch}'${NC}...\n"
else
    echo "Unknown branch name '$branch', should be one of [$BRANCHES]"
    exit 1
fi

# Отдельное предупреждение, если есть незакоммиченные изменнеия
git diff-index --quiet HEAD --;
if [ $? -ne 0 ]; then
    echo -n "Repo has untracked changes. Continue? (Y/N) "
    read answer
    if [ "$answer" != "${answer#[Yy]}" ];
    then
        echo "Continue...\n"
    else
        exit 1
    fi
fi

# Линт, чистка на всякий случай, сборка
npm run lint
rm -rf ./dist
npm run build

# Копирование
sleep 3
rsync -az --progress dist/ presentator@188.120.241.144:~/ais-expert-app/$branch/dist --delete-before \
&& printf "\n${GREEN}Done."
