#!/bin/sh
GREEN='\033[0;32m'
RED='\033[0;31m'
NC='\033[0m'

# Отдельное предупреждение, если есть незакоммиченные изменнеия
git diff-index --quiet HEAD --;
if [ $? -ne 0 ]; then
    echo -n "Repo has untracked changes. Continue? (Y/N) "
    read answer
    if [ "$answer" != "${answer#[Yy]}" ];
    then
        echo "Continue...\n"
    else
        exit 1
    fi
fi

# Линт, чистка на всякий случай, сборка
npm run lint
rm -rf ./dist
npm run build

# Копирование
sleep 3
rsync -az --progress dist/ piklab2@10.20.96.79:/opt/aisexpert-frontend/dist --delete-before \
&& printf "\n${GREEN}Done."
