#!/bin/sh

# Проверим наличие Гита
command -v git >/dev/null 2>&1 ||
{ echo "NO_GIT_NO_VERSION";
  exit;
}

LATEST_TAG=$(git describe --abbrev=0 --tags)
LATEST_TAG_WITHOUT_V=$(echo $LATEST_TAG | cut -c 2-)
LATEST_HASH=$(git rev-parse --short HEAD)

echo $LATEST_TAG_WITHOUT_V "("$LATEST_HASH")"
