const esModules = ['vue-spinner/src', 'vue-multiselect/src', 'element-ui'].join('|')

module.exports = {
    cache: false,
    moduleFileExtensions: [
        'js',
        'jsx',
        'json',
        'vue'
    ],
    transform: {
        '^.+\\.vue$': 'vue-jest',
        '.+\\.(css|styl|less|sass|scss|svg|png|jpg|ttf|woff|woff2)$': 'jest-transform-stub',
        '^.+\\.(js|jsx)$': 'babel-jest'
    },
    moduleNameMapper: {
        '^src/(.*)$': '<rootDir>/src/$1'
    },
    // фикс импорта .vue файлов из node_modules (https://github.com/vuejs/vue-cli/issues/1584)
    transformIgnorePatterns: [`<rootDir>/node_modules/(?!${esModules})`],
    snapshotSerializers: [
        'jest-serializer-vue'
    ],
    testMatch: [
        '**/tests/unit/**/*.spec.(js|jsx|ts|tsx)|**/__tests__/*.(js|jsx|ts|tsx)'
    ],
    testURL: 'http://localhost/'
}
